                                              
/* This module contains the PLM interface */
/* to many of the MsDos calls.            */


/* Xenix-like File Calls */


/* NOTE: Format of strings for file system  */
/* calls is ascii characters ending with 0. */

/* pError =>  Error,  a WORD value.  */

MsXnxOpen: PROCEDURE (pPathName, access, pError) WORD EXTERNAL;
  DCL access     BYTE;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsXnxCreate: PROCEDURE (pPathName, attribute, pError) WORD EXTERNAL;
  DCL attribute  WORD;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsXnxRead: PROCEDURE (conn, pBuffer, count, pError) WORD EXTERNAL;
  DCL conn       WORD;
  DCL count      WORD;
  DCL pBuffer    PTR;
  DCL pError     PTR;
  END;

/* NOTE: MsDos returns amount written */

MsXnxWrite: PROCEDURE (conn, pBuffer, count, pError) WORD EXTERNAL;
  DCL conn       WORD;
  DCL count      WORD;
  DCL pBuffer    PTR;
  DCL pError     PTR;
  END;

MsXnxSeek: PROCEDURE (conn, mode, count, pError) DWORD EXTERNAL;
  DCL mode       BYTE;
  DCL conn       WORD;
  DCL count      DWORD;
  DCL pError     PTR;
  END;

MsXnxRename: PROCEDURE (pOldName, pNewName, pError) EXTERNAL;
  DCL pOldName   PTR;
  DCL pNewName   PTR;
  DCL pError     PTR;
  END;

MsXnxDelete: PROCEDURE (pPathname, pError) EXTERNAL;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsXnxClose: PROCEDURE (conn, pError) EXTERNAL;
  DCL conn       WORD;
  DCL pError     PTR;
  END;

MsXnxFileTime: PROCEDURE (conn, mode, pTimeDate, pError) EXTERNAL;
  DCL mode       BYTE;
  DCL conn       WORD;
  DCL pTimeDate  PTR;
  DCL pError     PTR;
  END;
$EJECT

/* Xenix-like Directory Calls */

MsXnxCreateDir: PROCEDURE (pDirName, pError) EXTERNAL;
  DCL pDirName   PTR;
  DCL pError     PTR;
  END;

MsXnxDeleteDir: PROCEDURE (pDirName, pError) EXTERNAL;
  DCL pDirName   PTR;
  DCL pError     PTR;
  END;

MsXnxMatchFirst: PROCEDURE (attr, pPathname, pMatchBlk, pError) WORD EXTERNAL;
  DCL attr       WORD;
  DCL pPathName  PTR;
  DCL pMatchBlk  PTR;
  DCL pError     PTR;
  END;

MsXnxMatchNext: PROCEDURE (pMatchBlk, pError) WORD EXTERNAL;
  DCL pMatchBlk  PTR;
  DCL pError     PTR;
  END;


/* Xenix-like Misc Calls */


MsXnxGetFileAttr: PROCEDURE (pPathname, pError) WORD EXTERNAL;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsXnxSetFileAttr: PROCEDURE (pPathname, attr, pError) EXTERNAL;
  DCL attr       WORD;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;
$EJECT

/* Disk Calls */

MsGetDiskFreeSpace: PROCEDURE (drive, pInfo, pError) EXTERNAL;
  DCL drive      BYTE;
  DCL pInfo      PTR;
  DCL pError     PTR;
  END;

/* Misc Calls */

MsRandomNum: PROCEDURE BYTE EXTERNAL;
  END;

FcbGetVolumeName: PROCEDURE (pSearchBuf, pError) WORD EXTERNAL;
  DCL pSearchBuf PTR;
  DCL pError     PTR;
  END;

GetServerEntrypoint: PROCEDURE (pSignature, pError) PTR EXTERNAL;
  DCL pSignature PTR;
  DCL pError     PTR;
  END;

/* Get/Set Current Drive/Directory Calls */

MsGetCurrentDrive: PROCEDURE BYTE EXTERNAL;
  END;

MsSetCurrentDrive: PROCEDURE (drive) EXTERNAL;
  DCL drive      BYTE;
  END;

MsGetCurrentDir: PROCEDURE (pDir) EXTERNAL;
  DCL pDir       PTR;
  END;

MsSetCurrentDir: PROCEDURE (pDir) EXTERNAL;
  DCL pDir       PTR;
  END;

/* Load and Go call */

MsCreateProcess: PROCEDURE (exitPrompt, pPath, pLoadBlock, pError) EXTERNAL;
  DCL exitPrompt BOOLEAN;
  DCL pPath      PTR;
  DCL pLoadBlock PTR;
  DCL pError     PTR;
  END;
